#!/bin/bash

cd /mnt/c/Users/akima/adn-player-max

# Create ZIP
echo "Creating ZIP..."
zip -q adn_player_max.zip manifest.json content.js content.css popup.html popup.js README.md icon*.png

# Convert to base64
LOGO_B64=$(base64 -w 0 logo_adn_player_max.svg 2>/dev/null || base64 logo_adn_player_max.svg | tr -d '\n')
ZIP_B64=$(base64 -w 0 adn_player_max.zip 2>/dev/null || base64 adn_player_max.zip | tr -d '\n')

# Extract descriptions (first 500 chars for short description)
DESC_FR_SHORT="Maximisez instantanément le lecteur vidéo ADN pour une expérience anime immersive ! Extension 100% GRATUITE."
DESC_EN_SHORT="Instantly maximize ADN video player for an immersive anime experience! 100% FREE extension."

# Create minimal JSON
cat > product.json << 'EOJSON'
{
  "reference": "EXT-ADN-MAX-2025-V1",
  "name": {
    "fr": "ADN Player Max - Extension Chrome Gratuite",
    "en": "ADN Player Max - Free Chrome Extension"
  },
  "description_short": {
    "fr": "Maximisez instantanément le lecteur vidéo ADN pour une expérience anime immersive ! Extension 100% GRATUITE.",
    "en": "Instantly maximize ADN video player for an immersive anime experience! 100% FREE extension."
  },
  "price": "0.00",
  "meta_keywords": {
    "fr": "adn,animation digital network,lecteur video,maximiser,plein ecran,anime,streaming",
    "en": "adn,animation digital network,video player,maximize,fullscreen,anime,streaming"
  }
}
EOJSON

# Add file data
echo "Adding logo data..."
echo ",\"logo\":{\"filename\":\"logo.svg\",\"content\":\"$LOGO_B64\",\"mime_type\":\"image/svg+xml\"}" >> product_temp.json

echo "Adding ZIP data..."
echo ",\"download_file\":{\"filename\":\"adn_player_max.zip\",\"content\":\"$ZIP_B64\",\"mime_type\":\"application/zip\"}}" >> product_temp.json

# Merge JSON
sed '$ s/}$//' product.json > product_final.json
cat product_temp.json >> product_final.json

# Send to API
echo "Sending to API..."
curl -X POST \
  -H "Content-Type: application/json" \
  -d @product_final.json \
  "https://webpoint.fr/myprotect/api/extension_receiver.php"

# Cleanup
rm -f adn_player_max.zip product*.json

echo -e "\nDone!"