// ADN Player Max - Popup Script

// Gestion des onglets
document.addEventListener('DOMContentLoaded', () => {
    // Onglets
    const tabs = document.querySelectorAll('.tab');
    const tabContents = document.querySelectorAll('.tab-content');
    
    tabs.forEach(tab => {
        tab.addEventListener('click', () => {
            // Retirer la classe active de tous les onglets
            tabs.forEach(t => t.classList.remove('active'));
            tabContents.forEach(tc => tc.classList.remove('active'));
            
            // Ajouter la classe active à l'onglet cliqué
            tab.classList.add('active');
            const tabId = tab.getAttribute('data-tab');
            document.getElementById(tabId).classList.add('active');
        });
    });
    
    // Éléments du popup
    const statusDot = document.getElementById('statusDot');
    const statusText = document.getElementById('statusText');
    const statusLabel = document.getElementById('statusLabel');
    
    // Fonction pour mettre à jour l'interface
    function updateUI(isMaximized) {
        if (isMaximized) {
            statusDot.classList.remove('inactive');
            statusDot.classList.add('active');
            statusText.textContent = 'Lecteur maximisé';
            statusLabel.textContent = 'Actif';
        } else {
            statusDot.classList.remove('active');
            statusDot.classList.add('inactive');
            statusText.textContent = 'Mode normal';
            statusLabel.textContent = 'Inactif';
        }
    }
    
    // Vérifier l'état actuel
    chrome.tabs.query({ active: true, currentWindow: true }, (tabs) => {
        if (tabs[0].url.includes('animationdigitalnetwork.com')) {
            chrome.tabs.sendMessage(tabs[0].id, { action: 'getStatus' }, (response) => {
                if (chrome.runtime.lastError) {
                    // Content script pas encore prêt
                    statusText.textContent = 'Rechargez la page';
                    statusLabel.textContent = 'Non chargé';
                } else if (response) {
                    updateUI(response.maximized);
                }
            });
        } else {
            statusText.textContent = 'Visitez ADN';
            statusLabel.textContent = 'Inactif';
        }
    });
});

// Ouvrir les liens externes dans un nouvel onglet
document.querySelectorAll('a[target="_blank"]').forEach(link => {
    link.addEventListener('click', (e) => {
        e.preventDefault();
        chrome.tabs.create({ url: link.href });
    });
});