/**
 * Background script pour l'extension Devinox
 * Gère les événements en arrière-plan et l'initialisation
 */

// Événement déclenché lors de l'installation de l'extension
chrome.runtime.onInstalled.addListener((details) => {
    console.log('Extension Devinox installée !', details);
    
    // Initialiser les paramètres par défaut
    chrome.storage.sync.set({
        language: 'fr',
        wordLength: '5',
        theme: 'light',
        sound: false
    }, () => {
        console.log('Paramètres par défaut initialisés');
    });
});

// Événement déclenché lors du clic sur l'icône de l'extension
chrome.action.onClicked.addListener((tab) => {
    // Ouvre le popup.html au lieu de l'ouvrir automatiquement
    // Ce code n'est pas nécessaire si vous avez défini default_popup dans manifest.json
    // Mais il est utile si vous décidez de ne pas utiliser default_popup
    /*
    chrome.windows.create({
        url: chrome.runtime.getURL('popup.html'),
        type: 'popup',
        width: 400,
        height: 500
    });
    */
});

// Événement déclenché lorsqu'un message est envoyé à l'extension
chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
    console.log('Message reçu :', request);
    
    if (request.action === 'open_game') {
        // Ouvrir le jeu dans un nouvel onglet
        chrome.tabs.create({ url: chrome.runtime.getURL('index.html') });
        sendResponse({ success: true });
    }
    
    if (request.action === 'save_settings') {
        // Enregistrer les paramètres
        chrome.storage.sync.set(request.settings, () => {
            sendResponse({ success: true });
        });
        return true; // Pour indiquer que sendResponse sera appelé de manière asynchrone
    }
    
    if (request.action === 'get_settings') {
        // Récupérer les paramètres
        chrome.storage.sync.get({
            language: 'fr',
            wordLength: '5',
            theme: 'light',
            sound: false
        }, (settings) => {
            sendResponse({ settings });
        });
        return true; // Pour indiquer que sendResponse sera appelé de manière asynchrone
    }
});

// Fonction pour initialiser les paramètres
function initSettings() {
    chrome.storage.sync.get({
        language: 'fr',
        wordLength: '5',
        theme: 'light',
        sound: false
    }, (settings) => {
        console.log('Paramètres actuels :', settings);
    });
}

// Initialiser les paramètres
initSettings();