// Fix pour le Service Worker dans les extensions Chrome
(function() {
    // Désactiver complètement le service worker pour les extensions
    if ('serviceWorker' in navigator) {
        // Remplacer complètement l'objet serviceWorker
        navigator.serviceWorker = {
            // Simuler un register qui ne fait rien
            register: function() {
                console.log('[Extension] Service Worker désactivé pour compatibilité extension Chrome');
                return Promise.resolve({
                    installing: null,
                    waiting: null,
                    active: null,
                    scope: '/',
                    updateViaCache: 'imports',
                    onupdatefound: null,
                    onstatechange: null,
                    update: () => Promise.resolve(),
                    unregister: () => Promise.resolve(true),
                    addEventListener: () => {},
                    removeEventListener: () => {},
                    dispatchEvent: () => true
                });
            },
            
            // Autres méthodes que le code pourrait appeler
            ready: Promise.resolve({
                active: null,
                unregister: () => Promise.resolve(true)
            }),
            
            controller: null,
            
            getRegistration: function() {
                return Promise.resolve(null);
            },
            
            getRegistrations: function() {
                return Promise.resolve([]);
            },
            
            addEventListener: () => {},
            removeEventListener: () => {},
            dispatchEvent: () => true
        };
    }
    
    // Intercepter également window.caches qui pourrait causer des erreurs
    if (window.caches) {
        window.caches = {
            open: function() {
                console.log('[Extension] Cache API désactivée');
                return Promise.resolve({
                    put: () => Promise.resolve(),
                    delete: () => Promise.resolve(false),
                    keys: () => Promise.resolve([]),
                    match: () => Promise.resolve(null)
                });
            },
            has: () => Promise.resolve(false),
            keys: () => Promise.resolve([]),
            delete: () => Promise.resolve(false),
            match: () => Promise.resolve(null)
        };
    }
    
    console.log('[Extension] Service Worker et Cache désactivés pour compatibilité');
})();