/**
 * Script pour corriger le fonctionnement du bouton submit dans le jeu Devinox
 */

(function() {
    logger.log("Script de correction du bouton submit chargé");
    
    // Solution basée sur l'inspection du jeu original
    // Nous allons corriger l'interaction avec React
    
    // Attendre que le DOM soit chargé
    function init() {
        logger.log("Initialisation de la correction du bouton submit");
        
        // Le jeu utilise React, nous devons donc être prudents
        // Ne pas interférer avec les gestionnaires d'événements React
        
        // Intercepter tous les clics pour attraper le bouton submit sans interférer
        document.addEventListener('click', function(e) {
            // Trouver si le clic était sur un bouton submit ou l'un de ses descendants
            let target = e.target;
            
            // Vérifier la cible et ses parents
            while (target && target !== document) {
                // Vérifier si c'est notre bouton submit
                if (target.tagName === 'BUTTON' && 
                    (target.classList.contains('submit-btn') || 
                     (target.textContent && target.textContent.toLowerCase() === 'submit'))) {
                    
                    logger.log("Bouton submit cliqué, SANS INTERFÉRER");
                    
                    // NE PAS AJOUTER DE TRAITEMENT SPÉCIAL ICI
                    // NE PAS APPELER e.preventDefault() OU e.stopPropagation()
                    // Laissez React gérer l'événement normalement
                    
                    break;
                }
                
                target = target.parentElement;
            }
        }, true); // Utiliser la phase de capture pour être appelé avant React
        
        // Observer les modifications du DOM pour détecter l'ajout du bouton
        const observer = new MutationObserver(function() {
            // Vérifier si le bouton submit existe maintenant
            const submitButtons = document.querySelectorAll('button.submit-btn, button');
            
            // Parcourir tous les boutons pour trouver celui qui correspond
            submitButtons.forEach(function(button) {
                if (button.classList.contains('submit-btn') || 
                    (button.textContent && button.textContent.toLowerCase() === 'submit')) {
                    
                    logger.log("Bouton submit détecté dans le DOM");
                    
                    // NE PAS AJOUTER D'ÉCOUTEURS D'ÉVÉNEMENTS DIRECTEMENT
                    // Cela pourrait interférer avec React
                }
            });
        });
        
        // Observer tout le document pour les changements
        observer.observe(document.body, {
            childList: true,
            subtree: true
        });
        
        logger.log("Correction du bouton submit initialisée");
    }
    
    // Exécuter notre initialisation
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', init);
    } else {
        init();
    }
    
    // La clé est de ne PAS interférer avec React
    logger.log("Script de correction du bouton submit prêt");
})();