/**
 * Script d'injection V2 pour Devinox - Version simplifiée et plus robuste
 * Surveille les animations des tuiles pour détecter la validation des mots
 */

(function() {
    logger.log('🎮 Injection du message Devinox V2 activée');
    
    let isProcessing = false;
    let lastProcessedCells = 0;
    
    // Créer le conteneur de message
    function createMessageContainer() {
        const existing = document.getElementById('custom-message-v2');
        if (existing) return existing;
        
        const messageContainer = document.createElement('div');
        messageContainer.id = 'custom-message-v2';
        messageContainer.style.cssText = `
            position: fixed;
            top: 20%;
            left: 50%;
            transform: translate(-50%, -50%);
            background: linear-gradient(135deg, #2a2a2a 0%, #1a1a1a 100%);
            color: #ffcc00;
            padding: 20px 40px;
            border-radius: 10px;
            font-size: 18px;
            font-weight: bold;
            box-shadow: 0 4px 20px rgba(255, 204, 0, 0.3);
            border: 2px solid #ffcc00;
            z-index: 10000;
            display: none;
            text-align: center;
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            transition: all 0.3s ease;
        `;
        document.body.appendChild(messageContainer);
        return messageContainer;
    }
    
    // Afficher le message (version originale restaurée)
    function showMessage(text, color = '#ffcc00') {
        const container = createMessageContainer();
        container.textContent = text;
        container.style.color = color;
        container.style.borderColor = color;
        container.style.boxShadow = `0 4px 20px ${color}33`;
        container.style.display = 'block';
        container.style.opacity = '0';
        
        // Animation d'apparition
        setTimeout(() => {
            container.style.opacity = '1';
            container.style.transform = 'translate(-50%, -50%) scale(1.05)';
        }, 10);
        
        // Disparition
        setTimeout(() => {
            container.style.opacity = '0';
            container.style.transform = 'translate(-50%, -50%) scale(0.95)';
            setTimeout(() => {
                container.style.display = 'none';
            }, 300);
        }, 2000);
    }
    
    // Observer pour détecter quand le jeu est prêt
    const startObserver = new MutationObserver((mutations, obs) => {
        const board = document.querySelector('.board, [class*="board"], #board');
        if (board) {
            obs.disconnect();
            logger.log('✅ Board détecté, initialisation du système de messages');
            initMessageSystem();
        }
    });
    
    startObserver.observe(document.body, {
        childList: true,
        subtree: true
    });
    
    function initMessageSystem() {
        logger.log('🚀 Système de messages initialisé');
        
        // Surveiller les animations sur les cellules
        const checkForNewWord = () => {
            const cells = document.querySelectorAll('.board__cell');
            const animatedCells = Array.from(cells).filter(cell => {
                const animation = window.getComputedStyle(cell).animation || 
                                window.getComputedStyle(cell).animationName;
                return animation && animation !== 'none';
            });
            
            // Si des cellules sont en train d'être animées et qu'on n'est pas déjà en train de traiter
            if (animatedCells.length > 0 && !isProcessing) {
                isProcessing = true;
                logger.log('🎯 Animation détectée sur', animatedCells.length, 'cellules');
                
                // Attendre la fin de l'animation
                setTimeout(() => {
                    analyzeWord();
                    isProcessing = false;
                }, 1500); // Les animations durent généralement ~1s
            }
        };
        
        // Analyser le mot après validation
        function analyzeWord() {
            const cells = document.querySelectorAll('.board__cell');
            const validatedCells = Array.from(cells).filter(cell => {
                return cell.textContent.trim() && (
                    cell.classList.contains('absent') ||
                    cell.classList.contains('present') ||
                    cell.classList.contains('correct')
                );
            });
            
            logger.log('📊 Cellules validées:', validatedCells.length, 'Précédentes:', lastProcessedCells);
            
            // Si on a plus de cellules validées qu'avant
            if (validatedCells.length > lastProcessedCells) {
                const wordLength = parseInt(document.querySelector('select')?.value) || 5;
                const newCells = validatedCells.slice(-wordLength);
                
                // Vérifier si toutes les lettres sont correctes (victoire)
                const isWin = newCells.every(cell => cell.classList.contains('correct'));
                
                // Vérifier si c'est un mot invalide (message d'erreur visible)
                const errorVisible = Array.from(document.querySelectorAll('*')).some(el => {
                    if (!el || !el.textContent) return false;
                    
                    const text = el.textContent.toLowerCase();
                    const isVisible = el.offsetParent !== null;
                    
                    return isVisible && (
                        text.includes('introuvable') || 
                        text.includes('not found') ||
                        text.includes('pas dans') ||
                        text.includes('invalid') ||
                        text.includes('n\'existe pas') ||
                        text.includes('does not exist')
                    );
                });
                
                logger.log('🎮 Résultat - Victoire:', isWin, 'Erreur:', errorVisible);
                
                // Si victoire, afficher un message de félicitations
                if (isWin) {
                    logger.log('🎉 Affichage du message de victoire');
                    const victoryMessages = [
                        "Bravo ! Tu as trouvé ! 🎉",
                        "Excellent ! C'est le bon mot ! 🏆",
                        "Félicitations ! 🌟",
                        "Parfait ! Bien joué ! 🥇",
                        "Tu as réussi ! 🎯"
                    ];
                    const randomVictoryMessage = victoryMessages[Math.floor(Math.random() * victoryMessages.length)];
                    showMessage(randomVictoryMessage, '#4CAF50');
                }
                // Si erreur visible, ne rien faire (le jeu affiche déjà un message)
                // Si pas de victoire et pas d'erreur = mot valide mais pas le bon
                else if (!errorVisible) {
                    logger.log('💬 Affichage du message d\'encouragement');
                    const messages = [
                        "Ce n'est pas le bon mot ! 🤔",
                        "Pas encore... Continue ! 💪",
                        "Bien essayé ! Réessaie ! 🎯",
                        "Presque ! Tu y arrives ! 📈",
                        "Mot valide, mais pas celui-là ! 🔍",
                        "Continue comme ça ! 🌟",
                        "Tu chauffes ! 🔥",
                        "Pas mal ! Encore un effort ! 💡"
                    ];
                    const randomMessage = messages[Math.floor(Math.random() * messages.length)];
                    showMessage(randomMessage, '#ff9800');
                }
                
                lastProcessedCells = validatedCells.length;
            }
        }
        
        // Écouter tous les clics - IMPORTANT: NE PAS INTERFÉRER AVEC LE JEU
        document.addEventListener('click', (e) => {
            const target = e.target;
            
            // Ne détecter que les clics sur le clavier virtuel
            if (target.classList.contains('keyboard__key') || 
                target.classList.contains('key')) {
                
                // Ne plus faire d'action spécifique pour le bouton Enter
                // Juste enregistrer dans la console
                if (target.textContent && (
                    target.textContent.trim().toLowerCase() === 'enter' || 
                    target.textContent.trim().toLowerCase() === 'entrée' ||
                    target.textContent.trim() === '↵'
                )) {
                    logger.log("Bouton Enter cliqué");
                }
                
                // Comportement original du code
                setTimeout(checkForNewWord, 100);
                setTimeout(checkForNewWord, 300);
                setTimeout(checkForNewWord, 500);
            }
            
            // IMPORTANT: Ne pas traiter spécifiquement les clics sur BUTTON
            // pour éviter d'interférer avec le bouton submit
        });
        
        // Écouter la touche Entrée
        document.addEventListener('keydown', (e) => {
            if (e.key === 'Enter') {
                logger.log("Touche Enter pressée");
                
                // Comportement original du code
                setTimeout(checkForNewWord, 100);
                setTimeout(checkForNewWord, 300);
                setTimeout(checkForNewWord, 500);
            }
        });
        
        // Observer aussi les changements dans le DOM
        const gameObserver = new MutationObserver(() => {
            // Si on détecte des changements de classe sur les cellules
            const cells = document.querySelectorAll('.board__cell');
            const hasNewValidation = Array.from(cells).some(cell => {
                const classes = cell.className;
                return classes.includes('absent') || 
                       classes.includes('present') || 
                       classes.includes('correct');
            });
            
            if (hasNewValidation) {
                checkForNewWord();
            }
        });
        
        const board = document.querySelector('.board, [class*="board"]');
        if (board) {
            gameObserver.observe(board, {
                attributes: true,
                attributeFilter: ['class'],
                subtree: true,
                childList: true
            });
        }
        
        logger.log('✨ Système de messages V2 installé avec succès !');
    }
    
    // Si le jeu est déjà chargé
    if (document.querySelector('.board, [class*="board"]')) {
        initMessageSystem();
    }
})();