/**
 * Script de gestion des onglets et des paramètres de l'extension Devinox
 */

// Gestion des onglets
document.addEventListener('DOMContentLoaded', function() {
    // Activer les onglets
    document.querySelectorAll('.tab').forEach(tab => {
        tab.addEventListener('click', () => {
            document.querySelectorAll('.tab').forEach(t => t.classList.remove('active'));
            document.querySelectorAll('.tab-content').forEach(c => c.classList.remove('active'));
            
            tab.classList.add('active');
            document.getElementById(tab.dataset.tab).classList.add('active');
        });
    });
    
    // Charger les paramètres sauvegardés
    if (typeof chrome !== 'undefined' && chrome.storage) {
        chrome.storage.sync.get({
            language: 'fr',
            wordLength: '5',
            theme: 'light',
            sound: false
        }, (items) => {
            document.getElementById('language').value = items.language;
            document.getElementById('word-length').value = items.wordLength;
            document.getElementById('theme').value = items.theme;
            document.getElementById('sound').checked = items.sound;
        });
    }
    
    // Enregistrer les paramètres
    document.getElementById('save-settings').addEventListener('click', () => {
        const settings = {
            language: document.getElementById('language').value,
            wordLength: document.getElementById('word-length').value,
            theme: document.getElementById('theme').value,
            sound: document.getElementById('sound').checked
        };
        
        // Sauvegarder dans chrome.storage si disponible
        if (typeof chrome !== 'undefined' && chrome.storage) {
            chrome.storage.sync.set(settings, () => {
                showNotification('Paramètres sauvegardés !');
            });
        } else {
            localStorage.setItem('devinox_settings', JSON.stringify(settings));
            showNotification('Paramètres sauvegardés localement !');
        }
    });
    
    // Ouvrir le jeu
    document.getElementById('open-game').addEventListener('click', () => {
        if (typeof chrome !== 'undefined' && chrome.tabs) {
            // Ouvrir dans un nouvel onglet Chrome
            chrome.tabs.create({ url: 'index.html' });
        } else if (typeof chrome !== 'undefined' && chrome.runtime) {
            // Utiliser chrome.runtime.getURL pour obtenir l'URL absolue
            const gameUrl = chrome.runtime.getURL('index.html');
            window.open(gameUrl, '_blank');
        } else {
            window.open('index.html', '_blank');
        }
    });
    
    // Ajouter le raccourci clavier Alt+M
    document.addEventListener('keydown', (e) => {
        if (e.altKey && e.key.toLowerCase() === 'm') {
            if (typeof chrome !== 'undefined' && chrome.tabs) {
                chrome.tabs.create({ url: 'index.html' });
            } else {
                window.open('index.html', '_blank');
            }
        }
    });
    
    // Fonction pour afficher une notification
    function showNotification(message) {
        const notification = document.createElement('div');
        notification.textContent = message;
        notification.style.cssText = `
            position: fixed;
            top: 10px;
            left: 50%;
            transform: translateX(-50%);
            background: #4CAF50;
            color: white;
            padding: 10px 20px;
            border-radius: 5px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.2);
            z-index: 9999;
            font-weight: bold;
        `;
        
        document.body.appendChild(notification);
        
        setTimeout(() => {
            notification.style.opacity = '0';
            notification.style.transition = 'opacity 0.5s';
            setTimeout(() => {
                document.body.removeChild(notification);
            }, 500);
        }, 2000);
    }
});