/**
 * Ce script remplace complètement l'enregistrement du service worker
 * pour éviter les erreurs dans l'environnement d'une extension Chrome
 */

(function() {
    console.log('[Extension] Initialisation du service worker override...');
    
    // Fonction exécutée dès que le document est prêt
    function init() {
        console.log('[Extension] Service worker override actif');
        
        // Intercepter navigator.serviceWorker avant que le bundle JS principal ne l'utilise
        if ('serviceWorker' in navigator) {
            // Remplacer complètement l'objet serviceWorker
            navigator.serviceWorker = {
                // Une méthode register qui retourne une promesse résolue
                register: function(scriptURL, options) {
                    console.log('[Extension] Tentative d\'enregistrement de SW interceptée:', scriptURL);
                    return Promise.resolve({
                        // Propriétés standard d'un ServiceWorkerRegistration
                        scope: options?.scope || '/',
                        installing: null,
                        waiting: null,
                        active: null,
                        navigationPreload: { enable: () => Promise.resolve(), disable: () => Promise.resolve(), setHeaderValue: () => Promise.resolve() },
                        pushManager: { subscribe: () => Promise.resolve(null), getSubscription: () => Promise.resolve(null), permissionState: () => Promise.resolve('denied') },
                        sync: { register: () => Promise.resolve(), getTags: () => Promise.resolve([]) },
                        updateViaCache: 'imports',
                        
                        // Méthodes
                        update: () => Promise.resolve(),
                        unregister: () => Promise.resolve(true),
                        
                        // Gestionnaires d'événements
                        onupdatefound: null,
                        
                        // Méthodes d'événements
                        addEventListener: () => {},
                        removeEventListener: () => {},
                        dispatchEvent: () => true
                    });
                },
                
                // Autres propriétés/méthodes qui pourraient être utilisées
                ready: Promise.resolve({
                    active: null,
                    navigationPreload: { enable: () => Promise.resolve() },
                    pushManager: { subscribe: () => Promise.resolve(null) }
                }),
                
                controller: null,
                
                getRegistration: () => Promise.resolve(null),
                getRegistrations: () => Promise.resolve([]),
                
                startMessages: () => {},
                
                // Méthodes d'événements
                addEventListener: () => {},
                removeEventListener: () => {},
                dispatchEvent: () => true
            };
            
            // Simuler également messageEvent qui est souvent utilisé avec SW
            if (!window.MessageEvent) {
                window.MessageEvent = function MessageEvent(type, options) {
                    this.type = type;
                    this.data = options?.data || null;
                    this.origin = options?.origin || '';
                    this.source = options?.source || null;
                };
            }
        }
        
        // Désactiver également l'API Cache qui peut causer des erreurs
        if (window.caches) {
            window.caches = {
                open: () => Promise.resolve({
                    add: () => Promise.resolve(),
                    addAll: () => Promise.resolve(),
                    put: () => Promise.resolve(),
                    delete: () => Promise.resolve(false),
                    keys: () => Promise.resolve([]),
                    match: () => Promise.resolve(null)
                }),
                has: () => Promise.resolve(false),
                keys: () => Promise.resolve([]),
                delete: () => Promise.resolve(false),
                match: () => Promise.resolve(null)
            };
        }
    }
    
    // Exécuter immédiatement pour intercepter avant le chargement des autres scripts
    init();
    
    // Également exécuter après chargement du DOM au cas où
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', init);
    }
    
    // Également exécuter après le chargement complet de la page
    window.addEventListener('load', init);
})();