// Prime Video Auto Skip
let skipClicked = false;
let ffActive = false;
let settings = { skipIntro: true, skipAds: true };

// Charger les paramètres
chrome.storage.local.get(['skipIntro', 'skipAds'], (result) => {
    if (result.skipIntro !== undefined) settings.skipIntro = result.skipIntro;
    if (result.skipAds !== undefined) settings.skipAds = result.skipAds;
});

// Écouter les changements de paramètres
chrome.storage.onChanged.addListener((changes) => {
    if (changes.skipIntro) settings.skipIntro = changes.skipIntro.newValue;
    if (changes.skipAds) settings.skipAds = changes.skipAds.newValue;
});

// Countdown avant clic
function showCountdown(callback) {
    const countdown = document.createElement('div');
    countdown.style.cssText = `
        position: fixed;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        color: #00A8E1;
        font-size: 120px;
        font-weight: bold;
        font-family: Arial, sans-serif;
        z-index: 999999;
        text-shadow: 0 0 20px rgba(0, 0, 0, 0.9);
        pointer-events: none;
    `;
    
    document.body.appendChild(countdown);
    
    let count = 3;
    countdown.textContent = count;
    
    const interval = setInterval(() => {
        count--;
        if (count > 0) {
            countdown.textContent = count;
        } else {
            clearInterval(interval);
            document.body.removeChild(countdown);
            callback();
        }
    }, 1000);
}

// Détecter et cliquer sur Skip Intro/Résumé
function detectAndClickSkip() {
    if (!settings.skipIntro || skipClicked) return;
    
    // Chercher le bouton "Passer le résumé" ou "Skip Intro"
    const skipButton = document.querySelector('.atvwebplayersdk-skipelement-button');
    
    if (skipButton) {
        skipClicked = true;
        showCountdown(() => {
            skipButton.click();
            // Bouton cliqué
            setTimeout(() => {
                skipClicked = false;
            }, 30000); // 30 secondes avant de pouvoir recliquer
        });
    }
}

// Accélérer les pubs
function handleAds() {
    if (!settings.skipAds) return;
    
    // Détecter le timer de pub
    const adTimer = document.querySelector('.atvwebplayersdk-ad-timer-remaining-time');
    
    if (adTimer && !ffActive) {
        ffActive = true;
        // Pub détectée, accélération x8
        
        // Afficher indicateur
        const indicator = document.createElement('div');
        indicator.id = 'pv-fast-forward-indicator';
        indicator.textContent = '⏩ x8';
        indicator.style.cssText = `
            position: fixed;
            top: 20px;
            right: 20px;
            background: rgba(255, 0, 0, 0.8);
            color: white;
            padding: 10px 20px;
            border-radius: 5px;
            font-weight: bold;
            z-index: 999999;
            font-size: 18px;
        `;
        document.body.appendChild(indicator);
        
        // Accélérer toutes les vidéos
        const videos = document.querySelectorAll('video');
        videos.forEach(video => {
            video.muted = true;
            video.playbackRate = 8;
        });
    }
    
    // Vérifier si la pub est terminée
    if (ffActive && !document.querySelector('.atvwebplayersdk-ad-timer-remaining-time')) {
        ffActive = false;
        // Pub terminée, vitesse normale
        
        // Retirer l'indicateur
        const indicator = document.getElementById('pv-fast-forward-indicator');
        if (indicator) indicator.remove();
        
        // Restaurer vitesse normale
        const videos = document.querySelectorAll('video');
        videos.forEach(video => {
            video.muted = false;
            video.playbackRate = 1;
        });
    }
}

// Observer pour détecter les changements
const observer = new MutationObserver(() => {
    detectAndClickSkip();
    handleAds();
});

// Observer tout le body
observer.observe(document.body, {
    childList: true,
    subtree: true
});

// Vérifications périodiques
setInterval(() => {
    detectAndClickSkip();
    handleAds();
}, 500);

// Extension chargée