// Gestion des onglets
document.addEventListener('DOMContentLoaded', function() {
    // Onglets
    const tabs = document.querySelectorAll('.tab');
    const tabContents = document.querySelectorAll('.tab-content');
    
    tabs.forEach(tab => {
        tab.addEventListener('click', () => {
            // Retirer active de tous les onglets
            tabs.forEach(t => t.classList.remove('active'));
            tabContents.forEach(tc => tc.classList.remove('active'));
            
            // Ajouter active à l'onglet cliqué
            tab.classList.add('active');
            const tabId = tab.getAttribute('data-tab');
            document.getElementById(tabId).classList.add('active');
        });
    });
    
    // Charger les paramètres
    chrome.storage.local.get(['skipIntro', 'skipAds'], (result) => {
        document.getElementById('skipIntro').checked = result.skipIntro !== false;
        document.getElementById('skipAds').checked = result.skipAds !== false;
    });
    
    // Sauvegarder les changements
    document.getElementById('skipIntro').addEventListener('change', (e) => {
        chrome.storage.local.set({ skipIntro: e.target.checked });
    });
    
    document.getElementById('skipAds').addEventListener('change', (e) => {
        chrome.storage.local.set({ skipAds: e.target.checked });
    });
});