// ADN Player Max - Content Script

// État de l'extension
let isMaximized = false;

// Variables pour éviter les clics répétés
let introClicked = false;
let creditClicked = false;
let countdownActive = false;
let blockNextEpisode = false;
let EMERGENCY_STOP = false;
let lastNextClickTime = 0;
let lastClickTime = 0; // Pour bloquer après un clic

// Fonction pour créer le bouton de basculement
function createToggleButton() {
  // Vérifier si le bouton existe déjà
  if (document.getElementById('adn-toggle-button')) return;
  
  const button = document.createElement('button');
  button.id = 'adn-toggle-button';
  button.innerHTML = `
    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M7 9.5V7C7 6.44772 7.44772 6 8 6H10.5M17 9.5V7C17 6.44772 16.5523 6 16 6H13.5M17 14.5V17C17 17.5523 16.5523 18 16 18H13.5M7 14.5V17C7 17.5523 7.44772 18 8 18H10.5" stroke="white" stroke-width="2" stroke-linecap="round"/>
    </svg>
  `;
  button.style.cssText = `
    position: fixed !important;
    top: 20px !important;
    right: 20px !important;
    z-index: 2147483647 !important;
    width: 48px !important;
    height: 48px !important;
    border-radius: 50% !important;
    background: rgba(0, 0, 0, 0.8) !important;
    border: 2px solid rgba(255, 255, 255, 0.3) !important;
    cursor: pointer !important;
    display: flex !important;
    align-items: center !important;
    justify-content: center !important;
    transition: all 0.3s ease !important;
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.5) !important;
    opacity: 1 !important;
    visibility: visible !important;
  `;
  
  // Hover effect
  button.onmouseenter = () => {
    button.style.background = 'rgba(0, 0, 0, 0.9) !important';
    button.style.borderColor = 'rgba(255, 255, 255, 0.5) !important';
    button.style.transform = 'scale(1.1)';
  };
  
  button.onmouseleave = () => {
    button.style.background = 'rgba(0, 0, 0, 0.8) !important';
    button.style.borderColor = 'rgba(255, 255, 255, 0.3) !important';
    button.style.transform = 'scale(1)';
  };
  
  // Click handler
  button.onclick = () => {
    toggleMaximize();
    
    // Rotation animation
    button.style.transform = 'rotate(180deg)';
    setTimeout(() => {
      button.style.transform = 'rotate(0deg)';
    }, 300);
  };
  
  document.body.appendChild(button);
}

// Fonction pour maximiser le lecteur
function maximizePlayer() {
  try {
    // Ajouter la classe pour activer nos styles CSS
    document.body.classList.add('adn-player-maximized');
    isMaximized = true;
    
    // Trouver le lecteur vidéo
    const videoContainer = document.querySelector('.video-player-box, .player-container, [class*="player"]');
    const video = document.querySelector('video');
    
    if (videoContainer) {
      videoContainer.scrollIntoView({ behavior: 'smooth', block: 'center' });
    } else if (video) {
      video.scrollIntoView({ behavior: 'smooth', block: 'center' });
    }
    
    // Sauvegarder l'état avec vérification
    if (chrome.runtime?.id) {
      chrome.storage.local.set({ maximized: true });
    }
    
    // Créer le bouton si nécessaire
    createToggleButton();
  } catch (e) {
  }
}

// Fonction pour restaurer la vue normale
function restorePlayer() {
  try {
    document.body.classList.remove('adn-player-maximized');
    isMaximized = false;
    
    // Sauvegarder l'état avec vérification
    if (chrome.runtime?.id) {
      chrome.storage.local.set({ maximized: false });
    }
  } catch (e) {
  }
}

// Basculer entre les deux modes
function toggleMaximize() {
  if (isMaximized) {
    restorePlayer();
  } else {
    maximizePlayer();
  }
}

// Écouter les messages du popup
chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
  if (request.action === 'toggle') {
    toggleMaximize();
    sendResponse({ maximized: isMaximized });
  } else if (request.action === 'getStatus') {
    sendResponse({ maximized: isMaximized });
  }
});

// MAXIMISATION AUTOMATIQUE - Respecter l'état sauvegardé
function autoMaximize() {
  const hasVideo = document.querySelector('.video-js, #vjs_video_3, video');
  if (hasVideo) {
    // Vérifier si le contexte est valide
    if (chrome.runtime?.id) {
      // Récupérer l'état sauvegardé
      chrome.storage.local.get(['maximized'], (result) => {
        // Si pas d'état sauvegardé, maximiser par défaut
        const shouldMaximize = result.maximized !== false;
        
        if (shouldMaximize && !isMaximized) {
            maximizePlayer();
        } else if (!shouldMaximize && isMaximized) {
            restorePlayer();
        }
        
        // Créer le bouton dans tous les cas
        createToggleButton();
      });
    } else {
      // Si pas de contexte, maximiser par défaut
      maximizePlayer();
    }
  }
}

// Attendre que la page soit chargée puis maximiser
if (document.readyState === 'loading') {
  document.addEventListener('DOMContentLoaded', () => {
    setTimeout(autoMaximize, 1000);
    // Créer le bouton après le chargement
    setTimeout(createToggleButton, 1500);
  });
} else {
  setTimeout(autoMaximize, 1000);
  // Créer le bouton après le chargement
  setTimeout(createToggleButton, 1500);
}

// Raccourci clavier supprimé pour éviter les conflits

// Détecter quand on arrive sur une page vidéo et respecter l'état sauvegardé
const observer = new MutationObserver(() => {
  const hasVideo = document.querySelector('.video-js, #vjs_video_3, video');
  if (hasVideo && !document.body.classList.contains('adn-player-ready')) {
    document.body.classList.add('adn-player-ready');
    // Vérifier si le contexte est valide
    if (chrome.runtime?.id) {
      // Récupérer l'état sauvegardé
      chrome.storage.local.get(['maximized'], (result) => {
        const shouldMaximize = result.maximized !== false;
        
        setTimeout(() => {
          if (shouldMaximize && !isMaximized) {
            maximizePlayer();
          } else if (!shouldMaximize && isMaximized) {
            restorePlayer();
          }
        }, 1000);
      });
    } else {
      // Si pas de contexte, maximiser par défaut
      setTimeout(() => {
        if (!isMaximized) {
          maximizePlayer();
        }
      }, 1000);
    }
  }
  
  // S'assurer que le bouton existe toujours
  if (hasVideo && !document.getElementById('adn-toggle-button')) {
    createToggleButton();
  }
});

observer.observe(document.body, {
  childList: true,
  subtree: true
});

// Variable globale pour l'intervalle du compte à rebours
let countdownInterval = null;
let countdownModal = null;

// Fonction pour créer et afficher le compte à rebours
function showCountdown(text, callback) {
  // Ne pas vérifier countdownActive ici car on le met à true avant d'appeler cette fonction
  
  // Créer JUSTE LE CHIFFRE sans fond
  const countdown = document.createElement('div');
  countdown.id = 'adn-countdown-modal';
  countdown.style.cssText = `
    position: fixed;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    color: #ff6b35;
    font-size: 120px;
    font-weight: bold;
    font-family: Arial, sans-serif;
    z-index: 2147483648;
    text-shadow: 0 0 20px rgba(0, 0, 0, 0.9), 0 0 40px rgba(0, 0, 0, 0.9);
    pointer-events: none;
  `;
  
  document.body.appendChild(countdown);
  countdownModal = countdown;
  
  let count = 3;
  countdown.textContent = count;
  
  countdownInterval = setInterval(() => {
    // Vérifier l'arrêt d'urgence
    if (EMERGENCY_STOP) {
      clearInterval(countdownInterval);
      if (countdownModal && countdownModal.parentNode) {
        document.body.removeChild(countdownModal);
      }
      countdownActive = false;
      return;
    }
    
    count--;
    if (count > 0) {
      countdown.textContent = count;
    } else {
      clearInterval(countdownInterval);
      if (countdownModal && countdownModal.parentNode) {
        document.body.removeChild(countdownModal);
      }
      countdownActive = false;
      callback();
    }
  }, 1000);
}

// Fonction pour détecter et cliquer sur "Passer l'introduction" ou "Passer le générique"
function detectAndSkip() {
  // ARRÊT D'URGENCE - Appuyez sur "S" pour stopper
  if (EMERGENCY_STOP) {
    return;
  }
  
  // Réinitialiser countdownActive si le modal n'existe plus
  if (countdownActive && !document.getElementById('adn-countdown-modal')) {
    countdownActive = false;
  }
  
  // Si on est bloqué, ne rien faire
  if (blockNextEpisode) {
    return;
  }
  
  // Vérifier si la vidéo est en pause
  const video = document.querySelector('video');
  if (video && video.paused) {
    return;
  }
  
  // Si déjà en cours, ne rien faire
  if (countdownActive) return;
  
  // Bloquer pendant 8 secondes après un clic
  const now = Date.now();
  if (now - lastClickTime < 8000) return;
  
  // Chercher LE lien dans .vjs-dock-bottom
  const link = document.querySelector('.vjs-dock-bottom a');
  if (!link) return;
  
  // Vérifier si le parent vjs-dock-bottom est visible
  const dockBottom = link.closest('.vjs-dock-bottom');
  if (!dockBottom) return;
  
  // Vérifier la visibilité
  let parent = dockBottom;
  while (parent && parent !== document.body) {
    if (parent.classList.contains('vjs-hidden') || 
        parent.style.display === 'none' || 
        parent.style.visibility === 'hidden') {
      return; // Pas visible, on sort
    }
    parent = parent.parentElement;
  }
  
  // Le lien est visible - on lance le countdown
  countdownActive = true;
  
  showCountdown('Action automatique dans...', () => {
    link.click();
    
    // Enregistrer l'heure du clic
    lastClickTime = Date.now();
    
    // Réinitialiser countdownActive après un délai
    setTimeout(() => {
      countdownActive = false;
    }, 1000);
  });
}

// Observer pour détecter l'apparition des liens de skip
const skipObserver = new MutationObserver((mutations) => {
  // Vérifier spécifiquement les changements dans vjs-dock-bottom
  for (const mutation of mutations) {
    if (mutation.target.classList?.contains('vjs-dock-bottom') || 
        mutation.target.closest('.vjs-dock-bottom')) {
      detectAndSkip();
      return;
    }
  }
  detectAndSkip();
});

// Observer avec attributs pour détecter les changements de visibilité
skipObserver.observe(document.body, {
  childList: true,
  subtree: true,
  attributes: true,
  attributeFilter: ['style', 'class']
});

// Vérifier plus fréquemment pour une détection rapide
setInterval(detectAndSkip, 500);

// Supprimer l'observer des boutons cachés car on gère autrement maintenant

// Réinitialiser les flags quand on change de vidéo
let lastVideoUrl = window.location.href;
const videoObserver = new MutationObserver(() => {
  const currentUrl = window.location.href;
  if (currentUrl !== lastVideoUrl) {
    lastVideoUrl = currentUrl;
    
    // Réinitialiser TOUS les flags immédiatement
    introClicked = false;
    creditClicked = false;
    countdownActive = false;
    blockNextEpisode = false;
    lastNextClickTime = 0;
    
    // Nettoyer les attributs data-adn-clicked sur la nouvelle page
    setTimeout(() => {
      const allLinks = document.querySelectorAll('.vjs-dock-bottom a[data-adn-clicked]');
      allLinks.forEach(link => {
        link.removeAttribute('data-adn-clicked');
      });
    }, 1000);
  }
});

// Observer aussi les changements d'URL pour détecter le changement d'épisode
let urlCheckInterval = setInterval(() => {
  const currentUrl = window.location.href;
  if (currentUrl !== lastVideoUrl) {
    lastVideoUrl = currentUrl;
    
    // Réinitialiser TOUS les flags immédiatement
    introClicked = false;
    creditClicked = false;
    countdownActive = false;
    blockNextEpisode = false;
    lastNextClickTime = 0;
    
    // Nettoyer les attributs data-adn-clicked sur la nouvelle page
    setTimeout(() => {
      const allLinks = document.querySelectorAll('.vjs-dock-bottom a[data-adn-clicked]');
      allLinks.forEach(link => {
        link.removeAttribute('data-adn-clicked');
      });
    }, 1000);
  }
}, 1000);

videoObserver.observe(document.querySelector('head title') || document.head, {
  childList: true,
  subtree: true
});



// ARRÊT D'URGENCE - Touche S pour stopper/reprendre
document.addEventListener('keydown', (e) => {
  if (e.key === 's' || e.key === 'S') {
    EMERGENCY_STOP = !EMERGENCY_STOP;
    if (EMERGENCY_STOP) {
      alert('ADN Player Max - ARRÊT D\'URGENCE ACTIVÉ\nAppuyez sur S pour reprendre');
      // Réinitialiser tous les flags - FORCER countdownActive à false
      introClicked = false;
      creditClicked = false;
      countdownActive = false;
      blockNextEpisode = false;
      // Forcer aussi la suppression du modal s'il existe
      const modal = document.getElementById('adn-countdown-modal');
      if (modal) modal.remove();
    } else {
      alert('ADN Player Max - Extension réactivée');
    }
  }
});

// S'assurer que le bouton reste visible
setInterval(() => {
  if (!document.getElementById('adn-toggle-button')) {
    createToggleButton();
  }
}, 2000);