#!/usr/bin/env python3
import sys
print("Python version:", sys.version)

try:
    import os
    print("✓ os module imported")
except ImportError as e:
    print("✗ os module error:", e)

try:
    import json
    print("✓ json module imported")
except ImportError as e:
    print("✗ json module error:", e)

try:
    import zipfile
    print("✓ zipfile module imported")
except ImportError as e:
    print("✗ zipfile module error:", e)

try:
    import requests
    print("✓ requests module imported")
except ImportError as e:
    print("✗ requests module error:", e)
    print("Installing requests...")
    import subprocess
    subprocess.check_call([sys.executable, "-m", "pip", "install", "requests"])

try:
    import base64
    print("✓ base64 module imported")
except ImportError as e:
    print("✗ base64 module error:", e)

try:
    from datetime import datetime
    print("✓ datetime module imported")
except ImportError as e:
    print("✗ datetime module error:", e)

print("\nAll imports checked!")