#!/bin/bash

echo "🚀 ADN Player Max - PrestaShop Product Creator"
echo "=================================================="

# Create ZIP file
echo "📦 Creating extension ZIP..."
zip -r adn_player_max.zip manifest.json content.js content.css popup.html popup.js README.md icon*.png

# Convert files to base64
echo "🔄 Converting files to base64..."
LOGO_BASE64=$(base64 -w 0 logo_adn_player_max.svg)
ZIP_BASE64=$(base64 -w 0 adn_player_max.zip)
DESC_FR=$(cat description_fr.html | sed 's/"/\\"/g' | sed ':a;N;$!ba;s/\n/\\n/g')
DESC_EN=$(cat description_en.html | sed 's/"/\\"/g' | sed ':a;N;$!ba;s/\n/\\n/g')

# Create JSON payload
echo "📝 Creating JSON payload..."
cat > payload.json << EOF
{
  "reference": "EXT-ADN-MAX-2025-V1",
  "name": {
    "fr": "ADN Player Max - Extension Chrome Gratuite",
    "en": "ADN Player Max - Free Chrome Extension"
  },
  "description": {
    "fr": "$DESC_FR",
    "en": "$DESC_EN"
  },
  "description_short": {
    "fr": "Maximisez instantanément le lecteur vidéo ADN pour une expérience anime immersive ! Extension 100% GRATUITE.",
    "en": "Instantly maximize ADN video player for an immersive anime experience! 100% FREE extension."
  },
  "price": "0.00",
  "categories": ["Extensions Chrome", "Streaming", "Video", "Anime"],
  "tags": {
    "fr": ["adn", "animation digital network", "lecteur video", "maximiser", "plein ecran", "anime", "streaming", "chrome", "extension gratuite"],
    "en": ["adn", "animation digital network", "video player", "maximize", "fullscreen", "anime", "streaming", "chrome", "free extension"]
  },
  "meta_title": {
    "fr": "ADN Player Max - Extension Chrome Gratuite pour Maximiser ADN",
    "en": "ADN Player Max - Free Chrome Extension to Maximize ADN"
  },
  "meta_description": {
    "fr": "Extension Chrome gratuite pour maximiser le lecteur vidéo ADN. Profitez de vos animes en grand format ! Installation en 1 clic.",
    "en": "Free Chrome extension to maximize ADN video player. Enjoy your anime in large format! 1-click installation."
  },
  "meta_keywords": {
    "fr": "adn,animation digital network,lecteur video,maximiser,plein ecran,anime,streaming",
    "en": "adn,animation digital network,video player,maximize,fullscreen,anime,streaming"
  },
  "features": {
    "fr": [
      {"name": "Compatibilité", "value": "Chrome, Edge, Brave, Opera"},
      {"name": "Taille", "value": "< 100KB"},
      {"name": "Prix", "value": "GRATUIT"},
      {"name": "Installation", "value": "1 clic"},
      {"name": "Permissions", "value": "Minimales"}
    ],
    "en": [
      {"name": "Compatibility", "value": "Chrome, Edge, Brave, Opera"},
      {"name": "Size", "value": "< 100KB"},
      {"name": "Price", "value": "FREE"},
      {"name": "Installation", "value": "1 click"},
      {"name": "Permissions", "value": "Minimal"}
    ]
  },
  "logo": {
    "filename": "logo_adn_player_max.svg",
    "content": "$LOGO_BASE64",
    "mime_type": "image/svg+xml"
  },
  "download_file": {
    "filename": "adn_player_max.zip",
    "content": "$ZIP_BASE64",
    "mime_type": "application/zip"
  },
  "active": true,
  "visibility": "both",
  "condition": "new",
  "show_price": true,
  "available_for_order": true,
  "minimal_quantity": 1,
  "redirect_type": "404",
  "timestamp": "$(date -Iseconds)"
}
EOF

# Send to API
echo "📡 Sending to PrestaShop API..."
curl -X POST \
  -H "Content-Type: application/json" \
  -H "User-Agent: ADN-Player-Max-Creator/1.0" \
  -d @payload.json \
  "https://webpoint.fr/myprotect/api/extension_receiver.php" \
  -o response.json \
  -w "\nHTTP Status: %{http_code}\n"

# Show response
echo -e "\n📋 API Response:"
cat response.json | jq . 2>/dev/null || cat response.json

# Cleanup
echo -e "\n🧹 Cleaning up..."
rm -f adn_player_max.zip payload.json

echo -e "\n✨ Process completed!"