// Variable globale pour l'état
let isMaximized = false;

// Le bouton skip est dans l'iframe, donc géré par iframe-content.js

// Attendre 2 secondes avant de commencer le reste
setTimeout(() => {
    
    // Fonction pour agrandir le lecteur
    function maximizePlayer() {
        const playerWrapper = document.querySelector('.video-player-wrapper');
        if (playerWrapper) {
            playerWrapper.classList.add('cr-maximized');
            isMaximized = true;
            chrome.storage.local.set({ crMaximized: true });
            createToggleButton();
        } else {
            setTimeout(maximizePlayer, 1000);
        }
    }
    
    // Fonction pour restaurer la taille normale
    function restorePlayer() {
        const playerWrapper = document.querySelector('.video-player-wrapper');
        if (playerWrapper) {
            playerWrapper.classList.remove('cr-maximized');
            isMaximized = false;
            chrome.storage.local.set({ crMaximized: false });
        }
    }
    
    // Variable pour suivre si on a déjà cliqué
    let skipIntroClicked = false;
    
    // Fonction pour créer le bouton de basculement
    function createToggleButton() {
        // Vérifier si le bouton existe déjà
        if (document.getElementById('cr-toggle-button')) return;
        
        const button = document.createElement('button');
        button.id = 'cr-toggle-button';
        button.innerHTML = `
            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M7 9.5V7C7 6.44772 7.44772 6 8 6H10.5M17 9.5V7C17 6.44772 16.5523 6 16 6H13.5M17 14.5V17C17 17.5523 16.5523 18 16 18H13.5M7 14.5V17C7 17.5523 7.44772 18 8 18H10.5" stroke="white" stroke-width="2" stroke-linecap="round"/>
            </svg>
        `;
        button.style.cssText = `
            position: fixed;
            top: 20px;
            right: 20px;
            z-index: 99999;
            width: 48px;
            height: 48px;
            border-radius: 50%;
            background: rgba(0, 0, 0, 0.8);
            border: 2px solid rgba(255, 255, 255, 0.3);
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: all 0.3s ease;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.5);
        `;
        
        // Hover effect
        button.onmouseenter = () => {
            button.style.background = 'rgba(0, 0, 0, 0.9)';
            button.style.borderColor = 'rgba(255, 255, 255, 0.5)';
            button.style.transform = 'scale(1.1)';
        };
        
        button.onmouseleave = () => {
            button.style.background = 'rgba(0, 0, 0, 0.8)';
            button.style.borderColor = 'rgba(255, 255, 255, 0.3)';
            button.style.transform = 'scale(1)';
        };
        
        // Click handler
        button.onclick = () => {
            const playerWrapper = document.querySelector('.video-player-wrapper');
            if (playerWrapper) {
                if (isMaximized) {
                    restorePlayer();
                } else {
                    maximizePlayer();
                }
                
                // Rotation animation
                button.style.transform = 'rotate(180deg)';
                setTimeout(() => {
                    button.style.transform = 'rotate(0deg)';
                }, 300);
            }
        };
        
        document.body.appendChild(button);
    }
    
    
    // Observer pour détecter les changements de page (SPA)
    const observer = new MutationObserver((mutations) => {
        const hasPlayer = document.querySelector('.video-player-wrapper');
        
        // Si on trouve un nouveau lecteur
        if (hasPlayer && !hasPlayer.hasAttribute('data-cr-initialized')) {
            hasPlayer.setAttribute('data-cr-initialized', 'true');
            skipIntroClicked = false; // Réinitialiser pour le nouvel épisode
        }
        
        // S'assurer que le bouton existe toujours
        if (hasPlayer && !document.getElementById('cr-toggle-button')) {
            createToggleButton();
        }
    });
    
    // Observer le body pour les changements
    observer.observe(document.body, {
        childList: true,
        subtree: true
    });
    
    // Initialisation - Vérifier l'état sauvegardé
    chrome.storage.local.get(['crMaximized'], (result) => {
        // Si on a explicitement sauvegardé false, ne pas maximiser
        if (result.crMaximized === false) {
            createToggleButton();
            isMaximized = false;
        } else {
            // Sinon maximiser (par défaut ou si true)
            maximizePlayer();
        }
    });
    
    // Rien à arrêter ici car le skip est géré dans l'iframe
    
}, 2000); // Délai de 2 secondes

// Raccourci clavier supprimé pour éviter les conflits