// Script qui s'exécute DANS l'iframe du player

let skipClicked = false;

// Fonction pour afficher le countdown
function showCountdown(callback) {
    const countdown = document.createElement('div');
    countdown.style.cssText = `
        position: fixed;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        color: #ff6b35;
        font-size: 120px;
        font-weight: bold;
        font-family: Arial, sans-serif;
        z-index: 9999;
        text-shadow: 0 0 20px rgba(0, 0, 0, 0.9);
        pointer-events: none;
    `;
    
    document.body.appendChild(countdown);
    
    let count = 3;
    countdown.textContent = count;
    
    const interval = setInterval(() => {
        count--;
        if (count > 0) {
            countdown.textContent = count;
        } else {
            clearInterval(interval);
            document.body.removeChild(countdown);
            callback();
        }
    }, 1000);
}

// Fonction pour détecter et cliquer sur le bouton skip intro
function detectAndClickSkip() {
    if (skipClicked) return;
    
    const skipContainer = document.querySelector('[data-testid="skipButton"]');
    
    if (skipContainer) {
        const skipButton = skipContainer.querySelector('[role="button"]');
        if (skipButton) {
            skipClicked = true;
            showCountdown(() => {
                skipButton.click();
                setTimeout(() => {
                    skipClicked = false;
                }, 10000); // Attendre 10 secondes avant de pouvoir recliquer
            });
        }
    }
}

// Observer pour détecter quand le bouton est créé
const observer = new MutationObserver(() => {
    detectAndClickSkip();
});

// Observer tout le body de l'iframe
observer.observe(document.body, {
    childList: true,
    subtree: true
});

// Vérifier aussi régulièrement
setInterval(detectAndClickSkip, 1000);

// Script iframe chargé