// Cheat mode pour tests - Triple-clic sur le logo DEVINOX
// Version améliorée pour React/Redux
(function() {
    let clickCount = 0;
    let clickTimer = null;
    
    // Fonction pour modifier les points dans le localStorage
    function modifyPoints(newPoints) {
        try {
            // Récupérer l'état stocké
            const persistedState = localStorage.getItem('persist:root');
            if (persistedState) {
                const state = JSON.parse(persistedState);
                console.log('État actuel:', state);
                
                // Chercher où sont stockés les points
                for (let key in state) {
                    try {
                        const subState = JSON.parse(state[key]);
                        if (subState && subState.wp !== undefined) {
                            console.log(`Points trouvés dans ${key}:`, subState.wp);
                            subState.wp = newPoints;
                            state[key] = JSON.stringify(subState);
                            localStorage.setItem('persist:root', JSON.stringify(state));
                            console.log('Points modifiés dans localStorage!');
                            return true;
                        }
                    } catch (e) {
                        // Certaines clés peuvent ne pas être du JSON
                    }
                }
            }
        } catch (error) {
            console.error('Erreur lors de la modification du localStorage:', error);
        }
        return false;
    }
    
    // Fonction pour forcer la mise à jour de l'interface
    function forceUIUpdate(newPoints) {
        // Méthode 1: Modifier directement le DOM
        const pointsElement = document.querySelector('.header__points');
        if (pointsElement) {
            pointsElement.innerHTML = `${newPoints} <span>WP</span>`;
            pointsElement.style.color = '#00ff00';
            pointsElement.style.fontSize = '1.5em';
            setTimeout(() => {
                pointsElement.style.color = '';
                pointsElement.style.fontSize = '';
            }, 2000);
        }
        
        // Méthode 2: Chercher le store Redux dans window
        for (let key in window) {
            if (window[key] && window[key].getState && typeof window[key].getState === 'function') {
                try {
                    const state = window[key].getState();
                    console.log('Store Redux trouvé:', state);
                    
                    // Si on peut dispatcher une action
                    if (window[key].dispatch) {
                        // Essayer de dispatcher une action générique
                        window[key].dispatch({ type: 'UPDATE_WP', payload: newPoints });
                    }
                } catch (e) {}
            }
        }
        
        // Méthode 3: Chercher React dans les éléments DOM
        const rootElement = document.getElementById('root');
        if (rootElement) {
            const reactKeys = Object.keys(rootElement).filter(key => key.startsWith('__react'));
            if (reactKeys.length > 0) {
                console.log('React trouvé dans root');
                // Parcourir l'arbre React
                findAndUpdateWP(rootElement[reactKeys[0]], newPoints);
            }
        }
    }
    
    // Fonction récursive pour chercher et modifier wp dans l'arbre React
    function findAndUpdateWP(fiber, newPoints, depth = 0) {
        if (!fiber || depth > 30) return false;
        
        // Vérifier memoizedProps
        if (fiber.memoizedProps && typeof fiber.memoizedProps === 'object') {
            if (updateWPInObject(fiber.memoizedProps, newPoints)) return true;
        }
        
        // Vérifier memoizedState
        if (fiber.memoizedState && typeof fiber.memoizedState === 'object') {
            if (updateWPInObject(fiber.memoizedState, newPoints)) return true;
        }
        
        // Parcourir l'arbre
        if (fiber.child && findAndUpdateWP(fiber.child, newPoints, depth + 1)) return true;
        if (fiber.sibling && findAndUpdateWP(fiber.sibling, newPoints, depth + 1)) return true;
        if (fiber.return && findAndUpdateWP(fiber.return, newPoints, depth + 1)) return true;
        
        return false;
    }
    
    // Fonction pour mettre à jour wp dans un objet
    function updateWPInObject(obj, newPoints) {
        if (obj.wp !== undefined) {
            console.log('WP trouvé et modifié:', obj.wp, '->', newPoints);
            obj.wp = newPoints;
            return true;
        }
        
        // Chercher récursivement (mais pas trop profond)
        for (let key in obj) {
            if (obj[key] && typeof obj[key] === 'object' && !key.startsWith('_')) {
                if (obj[key].wp !== undefined) {
                    obj[key].wp = newPoints;
                    return true;
                }
            }
        }
        return false;
    }
    
    // Fonction d'initialisation
    function initCheatMode() {
        const titleElement = document.querySelector('.header__title');
        
        if (!titleElement) {
            setTimeout(initCheatMode, 500);
            return;
        }
        
        console.log('Triple-clic activé sur le titre DEVINOX!');
        
        titleElement.style.cursor = 'pointer';
        titleElement.title = 'Triple-clic pour activer le mode test';
        
        titleElement.addEventListener('click', function(e) {
            clickCount++;
            
            if (clickTimer) clearTimeout(clickTimer);
            
            clickTimer = setTimeout(() => {
                clickCount = 0;
            }, 500);
            
            if (clickCount === 3) {
                console.log('🎮 CHEAT MODE ACTIVÉ! 🎮');
                
                const newPoints = 2000;
                
                // Essayer toutes les méthodes
                const localStorageModified = modifyPoints(newPoints);
                forceUIUpdate(newPoints);
                
                // Message de confirmation
                const msg = document.createElement('div');
                msg.textContent = '🎮 CHEAT MODE: ' + newPoints + ' WP! 🎮';
                msg.style.cssText = `
                    position: fixed;
                    top: 50%;
                    left: 50%;
                    transform: translate(-50%, -50%);
                    background: #00ff00;
                    color: black;
                    padding: 20px;
                    border-radius: 10px;
                    font-size: 24px;
                    font-weight: bold;
                    z-index: 9999;
                    animation: pulse 0.5s ease-in-out;
                `;
                document.body.appendChild(msg);
                
                setTimeout(() => msg.remove(), 2000);
                
                if (localStorageModified) {
                    console.log('💾 Points sauvegardés dans localStorage - Rechargez la page si nécessaire');
                }
                
                clickCount = 0;
            }
        });
    }
    
    // Ajouter les styles d'animation
    const style = document.createElement('style');
    style.textContent = `
        @keyframes pulse {
            0% { transform: translate(-50%, -50%) scale(0.8); }
            50% { transform: translate(-50%, -50%) scale(1.2); }
            100% { transform: translate(-50%, -50%) scale(1); }
        }
    `;
    document.head.appendChild(style);
    
    // Lancer l'initialisation
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', initCheatMode);
    } else {
        initCheatMode();
    }
})();