// Script pour surbrillance orange des touches sélectionnées - Version simple
(function() {
    console.log('Keyboard highlight script loaded!');
    
    // Styles CSS pour la surbrillance orange et indices bleu ciel
    const style = document.createElement('style');
    style.textContent = `
        .keyboard-button.selected-key {
            background-color: #ff8c00 !important;
            color: white !important;
            transform: scale(1.1);
            transition: all 0.2s ease;
            box-shadow: 0 0 10px #ff8c00;
        }
        
        /* Lettres achetées avec indices - Bleu ciel au lieu de noir/gris */
        .keyboard-button.absent {
            background-color: #87CEEB !important;
            color: #000 !important;
            border: 2px solid #5F9FCE !important;
            font-weight: bold !important;
        }
        
        /* Animation pour attirer l'attention sur les lettres achetées */
        .keyboard-button.absent {
            animation: pulse-blue 2s ease-in-out infinite;
        }
        
        @keyframes pulse-blue {
            0% { box-shadow: 0 0 5px #87CEEB; }
            50% { box-shadow: 0 0 20px #87CEEB, 0 0 30px #5F9FCE; }
            100% { box-shadow: 0 0 5px #87CEEB; }
        }
    `;
    document.head.appendChild(style);
    
    // Attendre un peu que le jeu se charge
    setTimeout(function() {
        console.log('Initialisation du highlight...');
        
        // Variable pour stocker les lettres tapées
        let typedLetters = [];
        
        // Intercepter TOUS les clics dans le document
        document.body.addEventListener('click', function(e) {
            // Si c'est un bouton du clavier
            if (e.target && e.target.classList && e.target.classList.contains('keyboard-button')) {
                const letter = e.target.textContent.trim();
                
                if (letter === 'ENTER') {
                    // Effacer tout
                    document.querySelectorAll('.keyboard-button').forEach(btn => {
                        btn.classList.remove('selected-key');
                    });
                    typedLetters = [];
                    console.log('ENTER pressé - reset');
                } else if (letter === '⌫') {
                    // Enlever la dernière lettre
                    if (typedLetters.length > 0) {
                        const lastLetter = typedLetters.pop();
                        // Trouver et désélectionner ce bouton
                        document.querySelectorAll('.keyboard-button').forEach(btn => {
                            if (btn.textContent.trim() === lastLetter) {
                                btn.classList.remove('selected-key');
                            }
                        });
                    }
                } else if (letter.length === 1) {
                    // Ajouter la lettre
                    typedLetters.push(letter);
                    e.target.classList.add('selected-key');
                    console.log('Lettre ajoutée:', letter);
                }
            }
        });
        
        // Intercepter aussi le clavier physique
        document.addEventListener('keydown', function(e) {
            if (e.key === 'Enter') {
                // Effacer tout
                document.querySelectorAll('.keyboard-button').forEach(btn => {
                    btn.classList.remove('selected-key');
                });
                typedLetters = [];
            } else if (e.key === 'Backspace') {
                // Enlever la dernière lettre
                if (typedLetters.length > 0) {
                    const lastLetter = typedLetters.pop();
                    document.querySelectorAll('.keyboard-button').forEach(btn => {
                        if (btn.textContent.trim() === lastLetter.toUpperCase()) {
                            btn.classList.remove('selected-key');
                        }
                    });
                }
            } else if (e.key.length === 1 && e.key.match(/[a-zA-Z]/)) {
                const letter = e.key.toUpperCase();
                typedLetters.push(letter);
                // Trouver et sélectionner le bouton
                document.querySelectorAll('.keyboard-button').forEach(btn => {
                    if (btn.textContent.trim() === letter) {
                        btn.classList.add('selected-key');
                    }
                });
            }
        });
        
    }, 1000); // Attendre 1 seconde que le jeu se charge
})();