/**
 * Utilitaire de journalisation sécurisé pour Devinox
 * Désactive automatiquement les logs en production
 */

(function() {
    // Définir si nous sommes en mode développement ou production
    // En production, cette valeur sera false
    const isDevelopment = false;
    
    // Créer un objet logger global
    window.logger = {
        // Méthodes standard qui correspondent à console.*
        log: function() {
            if (isDevelopment) {
                console.log.apply(console, arguments);
            }
        },
        
        info: function() {
            if (isDevelopment) {
                console.info.apply(console, arguments);
            }
        },
        
        warn: function() {
            if (isDevelopment) {
                console.warn.apply(console, arguments);
            }
        },
        
        error: function() {
            // Les erreurs sont toujours journalisées même en production
            // car elles sont importantes pour le débogage
            console.error.apply(console, arguments);
        },
        
        debug: function() {
            if (isDevelopment) {
                console.debug.apply(console, arguments);
            }
        }
    };
    
    // Si l'extension est déjà initialisée, ne pas réinitialiser
    if (!window.devinoxInitialized) {
        window.devinoxInitialized = true;
        logger.log('Logger Devinox initialisé');
    }
})();