/**
 * Script patcher pour Devinox Extension
 * Désactive le service worker dans le bundle JS
 */

(function() {
    console.log('[Extension] Patch pour le bundle JavaScript actif');
    
    // Fonction exécutée une fois que le DOM est chargé
    function patchBundle() {
        try {
            // Désactiver la fonction Qa qui enregistre le service worker
            window.Qa = function(scriptUrl, options) {
                console.log('[Extension] Tentative d\'enregistrement du service worker interceptée:', scriptUrl);
                // Simuler une promesse résolue
                return Promise.resolve({
                    onupdatefound: null,
                    installing: null,
                    waiting: null,
                    active: null,
                    scope: '/',
                    update: function() { return Promise.resolve(); },
                    unregister: function() { return Promise.resolve(true); }
                });
            };
            
            // Définir navigator.serviceWorker avant tout
            if ('serviceWorker' in navigator) {
                navigator.serviceWorker = {
                    register: function() {
                        console.log('[Extension] Register du service worker intercepté');
                        return Promise.resolve({
                            onupdatefound: null,
                            installing: null,
                            waiting: null,
                            active: null
                        });
                    },
                    ready: Promise.resolve({
                        active: null
                    }),
                    controller: null,
                    getRegistration: function() { return Promise.resolve(null); },
                    getRegistrations: function() { return Promise.resolve([]); }
                };
            }
            
            // Patch spécifique pour le problème split 
            if (typeof Ga !== 'undefined') {
                // Forcer Ga à false
                window.Ga = false;
            }
            
            console.log('[Extension] Bundle JavaScript patché avec succès');
        } catch (e) {
            console.error('[Extension] Erreur lors du patch du bundle:', e);
        }
    }
    
    // Exécuter avant le chargement complet
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', patchBundle);
    } else {
        patchBundle();
    }
    
    // Aussi exécuter après le chargement
    window.addEventListener('load', patchBundle);
})();