/**
 * Script de gestion du son pour Devinox
 * Extrait de l'ancien script inline pour respecter la CSP
 */

// Variable globale pour l'état du son
let isMuted = true;

window.addEventListener('load', function() {
    // Couper tous les sons
    document.querySelectorAll('audio, video').forEach(media => {
        media.muted = true;
        media.volume = 0;
    });
    
    // Intercepter la création de nouveaux éléments audio
    const originalAudio = window.Audio;
    window.Audio = function(...args) {
        const audio = new originalAudio(...args);
        audio.muted = isMuted;
        audio.volume = isMuted ? 0 : 1;
        return audio;
    };
    
    // Pour Howler.js si utilisé
    if (window.Howler) {
        window.Howler.mute(true);
    }
});

// Écouter les messages du parent
window.addEventListener('message', function(e) {
    if (e.data && e.data.type === 'toggle-sound') {
        isMuted = e.data.muted;
        
        // Pour tous les éléments audio/video
        document.querySelectorAll('audio, video').forEach(media => {
            media.muted = isMuted;
            media.volume = isMuted ? 0 : 1;
        });
        
        // Pour Howler.js
        if (window.Howler) {
            window.Howler.mute(isMuted);
        }
    }
});

// Fonction pour définir l'état du son
function setSoundState(state) {
    isMuted = !state;
    
    // Appliquer aux éléments audio/video
    document.querySelectorAll('audio, video').forEach(media => {
        media.muted = isMuted;
        media.volume = isMuted ? 0 : 1;
    });
    
    // Pour Howler.js
    if (window.Howler) {
        window.Howler.mute(isMuted);
    }
}

// Écouter les messages de l'extension et de l'iframe parent
window.addEventListener('message', function(event) {
    // Vérifier si le message est de type settings
    if (event.data && event.data.type === 'settings') {
        // Appliquer les paramètres de son
        if (typeof event.data.data.sound !== 'undefined') {
            setSoundState(event.data.data.sound);
            console.log('Son ' + (event.data.data.sound ? 'activé' : 'désactivé') + ' via message');
        }
        
        // Appliquer d'autres paramètres si nécessaire
        // Par exemple, la langue, la longueur des mots, etc.
    }
});

// Également écouter les messages de l'extension Chrome
if (typeof chrome !== 'undefined' && chrome.runtime) {
    chrome.runtime.onMessage.addListener(function(request, sender, sendResponse) {
        if (request.action === 'set_sound') {
            setSoundState(request.enabled);
            sendResponse({success: true});
        }
    });
}